/************************************************************************************
* Include
***********************************************************************************/
#include "fsl_common.h"
#include "ntag_defines.h"
#include "ntag_driver.h"
#include "nfc_device.h"
//#include "NDEF_Status.h"
/************************************************************************************
* Public Macros and Definitions
***********************************************************************************/
#ifdef I2C_FSL
#define NTAG_I2C_MASTER_BASEADDR I2C1
#define I2C_MASTER_CLK_SRC I2C1_CLK_SRC
#endif

#define NDEF_MSG_LEN_MAX_1K 880 // (page_55 - page_0) * 16_bytes/page
#define NDEF_MSG_LEN_MAX_2K 1904 // (page_127 - page_63) * 16_bytes/page + NDEF_MSG_LEN_MAX_1K
#define NDEF_MSG_LEN_1B_TLV 0x00FF
#define NDEF_MSG_LEN_3B_TLV 0xFFFF

#define NULL_TLV 0x00
#define LOCK_CONTROL_TLV 0x01
#define MEMORY_CONTROL_TLV 0x02
#define NDEF_MESSAGE_TLV 0x03
#define PROPRIETARY_TLV 0xFD
#define TERMINATOR_TLV 0xFE

#define NDEF_MSG_TLV_LEN_LONG 4
#define NDEF_MSG_TLV_LEN_SHORT 2

#define NDEF_WRITE_TIMEOUT 2

#define NDEF_BLE_FLAGS            0x01
#define NDEF_BLE_UUID_START       0x02
#define NDEF_BLE_UUID_END         0x07
#define NDEF_BLE_LOCAL_NAME0      0x08
#define NDEF_BLE_LOCAL_NAME1      0x09
#define NDEF_BLE_CLASS_OF_DEVICE  0x0D
#define NDEF_BLE_HASH_C           0x0E
#define NDEF_BLE_RANDOMIZER_R     0x0F
#define NDEF_BLE_TK_VALUE         0x10
#define NDEF_BLE_APPEARANCE       0x19
#define NDEF_BLE_BD_ADDRESS       0x1B
#define NDEF_BLE_ROLE             0x1C





static const uint8_t Default_Empty_NDEF_msg[] =
{
		0xAA, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00,
		0xE1, 0x10, 0x6D, 0x00,
		0x03, 0x03, 0xD0, 0x00,
		0x00, 0xFE, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00
};
/************************************************************************************
* Public macros
***********************************************************************************/
/************************************************************************************
* Public memory declarations
***********************************************************************************/
static const uint8_t Null_Block[] = {
		0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00
};

static const uint8_t Default_Page_56[] = {
		0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0xFF
};

static const uint8_t Default_Page_57[] = {
		0x00, 0x00, 0x00, 0x00,
		0xFF, 0xFF, 0xFF, 0xFF,
		0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00
};

static const uint8_t Default_Page_58[] = {
		0x01, 0x00, 0xF8, 0x48,
		0x08, 0x01, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00
};

extern NFC_HANDLE_T ntag_handle; // NTAG


/************************************************************************************
* Public prototypes
***********************************************************************************/
status_t NDEF_Pairing_Write(void);
status_t NDEF_Demo_Write(void);
/************************************************************************************
* end of file
***********************************************************************************/